# Installation
From the root of the code (the folder `orbit-gnn`), create a new `python3` virtual environment with:
```
python3 -m venv ./venv
```
Then activate the environment with:
```
source venv/bin/activate
```
Then install the following required packages using `pip`. If difficulties are encountered, instructions for installing `torch` can be found [here](https://pytorch.org/get-started/locally/) and instructions for `torch_geometric` can be found [here](https://pytorch-geometric.readthedocs.io/en/latest/notes/installation.html).
```
pip3 install torch torchvision torchaudio
pip3 install torch_geometric
pip3 install pyg_lib torch_scatter torch_sparse torch_cluster torch_spline_conv -f https://data.pyg.org/whl/torch-2.0.0+cpu.html
pip3 install networkx==3.0
pip3 install wandb
pip3 install matplotlib
```

A different version of CUDA can be used, depending on your system.

# Running Experiments
To run the `rni_gcn` model on the `bioisostere` dataset with 4 `gnn_layers`, execute the following command from within the virtual environment:

```
python3 main.py --dataset bioisostere --model rni_gcn --gnn_layers 4
```

Full model hyperparameters can be found in Appendix C.3 of the paper and passed as arguments to the program in the same way that `gnn_layers` was set above.
